% This function Normalizes the tSNE feature space between [0,1] and
% visualize it as a 2D spatial image
function tSNE_SegMap_Gray = Normalize_tSNESpatialImage(mappedX,S,indx)

dim3 = size(mappedX,2);

if(dim3==1)
    max1 = max(mappedX(:)); min1 = min(mappedX(:));
    mappedX_Norm = (mappedX - min1)/(max1 - min1);
    tSNE_SegmentationMap_Norm = Visualize_tSNE_2DImage(mappedX_Norm,S(1),S(2),indx);
    tSNE_SegMap_Gray = tSNE_SegmentationMap_Norm;
    figure, imagesc(tSNE_SegMap_Gray); figure, imagesc(edge(tSNE_SegMap_Gray));
    
elseif(dim3==2)
    tSNE_1 = mappedX(:,1); max1 = max(tSNE_1(:)); min1 = min(tSNE_1(:));
    tSNE_2 = mappedX(:,2); max2 = max(tSNE_2(:)); min2 = min(tSNE_2(:));
    tSNE_1_Norm = (tSNE_1 - min1)/(max1 - min1);
    tSNE_2_Norm = (tSNE_2 - min2)/(max2 - min2);
    mappedX_Norm(:,1) = tSNE_1_Norm;
    mappedX_Norm(:,2) = tSNE_2_Norm;
    tSNE_SegmentationMap_Norm = Visualize_tSNE_2DImage(mappedX_Norm,S(1),S(2),indx);
    tSNE_SegMap_Gray = rgb2gray(tSNE_SegmentationMap_Norm);
    figure, imagesc(tSNE_SegMap_Gray); figure, imagesc(edge(tSNE_SegMap_Gray));
else
    tSNE_1 = mappedX(:,1); max1 = max(tSNE_1(:)); min1 = min(tSNE_1(:));
    tSNE_2 = mappedX(:,2); max2 = max(tSNE_2(:)); min2 = min(tSNE_2(:));
    tSNE_3 = mappedX(:,3); max3 = max(tSNE_3(:)); min3 = min(tSNE_3(:));
    tSNE_1_Norm = (tSNE_1 - min1)/(max1 - min1);
    tSNE_2_Norm = (tSNE_2 - min2)/(max2 - min2);
    tSNE_3_Norm = (tSNE_3 - min3)/(max3 - min3);
    mappedX_Norm(:,1) = tSNE_1_Norm;
    mappedX_Norm(:,2) = tSNE_2_Norm;
    mappedX_Norm(:,3) = tSNE_3_Norm;
    tSNE_SegmentationMap_Norm = Visualize_tSNE_2DImage(mappedX_Norm,S(1),S(2),indx);
    tSNE_SegMap_Gray = rgb2gray(tSNE_SegmentationMap_Norm);
    figure, imagesc(tSNE_SegMap_Gray); figure, imagesc(edge(tSNE_SegMap_Gray,'canny'));
end